/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.mccs;

import com.quantumdata.mccs.CommonPanel;
import com.quantumdata.mccs.Constants;
import com.quantumdata.mccs.JTextFieldLimit;
import com.quantumdata.mccs.MCCSGUIFrame;
import com.quantumdata.mccs.VCPCodes;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class DisplayColorPanel
extends CommonPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final int HORIZONTAL_FREQ = 0;
    private final int VERTICAL_FREQ = 1;
    private final int SOURCE_TIMING_MODE = 2;
    private final int SOURCE_COLOR_CODING = 3;
    private final int DISPLAY_USAGE_TIME = 4;
    private final int DISPLAY_CONTROLLER_TYPE = 5;
    private final int DISPLAY_FIRMWARE_LEVEL = 6;
    private final int OSD = 7;
    private final int OSD_LANGUAGE = 8;
    private final int POWER_MODE = 9;
    private final int IMAGE_MODE = 10;
    private final int VCP_VERSION = 11;
    private JTextField jTextHorizontalFreqVal;
    private JTextField jTextHorizontalFreqUnit;
    private JTextField jTextVerticalFreqVal;
    private JTextField jTextVerticalFreqUnit;
    private JTextField jTextDTVTimingMode;
    private JComboBox jComboDTVTimingMode;
    private JTextField jTextDMTTimingMode;
    private JComboBox jComboDMTTimingMode;
    private JCheckBox jCheckCVTDefined;
    private JPanel jCvtPanel;
    private JTextField jTextVSize;
    private JTextField jTextVSizeVal;
    private JTextField jTextAspectRatio;
    private JComboBox jComboAspectRatio;
    private JTextField jTextPreferredRefreshRate;
    private JComboBox jComboPreferredRefreshRate;
    private JTextField jTextSupportedRefreshRate;
    private JCheckBox jCheckSupport50Hz;
    private JCheckBox jCheckSupport60Hz;
    private JCheckBox jCheckSupport75Hz;
    private JCheckBox jCheckSupport85Hz;
    private JCheckBox jCheckSupport60HzReduced;
    private JButton jSetSourceTimingModeButton;
    private JComboBox jComboSourceColorCoding;
    private JButton jSetSourceColorCodingButton;
    private JTextField jTextDisplayUsageTimeVal;
    private String[] jControllerManufacturer;
    private JTextField jTextControllerManufacturer;
    private JTextField jTextControllerManufacturerVal;
    private JTextField jTextControllerTypeNum;
    private JTextField jTextControllerTypeNumVal;
    private JTextField jTextDisplayFirmwareLevelVal;
    private JComboBox jComboOsd;
    private JButton jSetOsdButton;
    private JComboBox jComboOsdLanguage;
    private JButton jSetOsdLanguageButton;
    private JComboBox jComboPowerMode;
    private JButton jSetPowerModeButton;
    private JComboBox jComboImageMode;
    private JButton jSetImageModeButton;
    private JTextField jTextVCPVerNumber;

    public DisplayColorPanel() {
        super(12);
        this.addHorizontalFreq();
        this.addVeritcalFreq();
        this.addSourceTimingMode();
        this.addSourceColorCoding();
        this.addDisplayUsageTime();
        this.addDisplayControllerType();
        this.addDisplayFirmwareLevel();
        this.addOSD();
        this.addOSDLanguage();
        this.addPowerMode();
        this.addImageMode();
        this.addVCPVersion();
        this.constructPanel();
    }

    private void addHorizontalFreq() {
        this.vcpCodes[0] = new VCPCodes("Horizontal Frequency", "AC", "RO", "C");
        this.jTextHorizontalFreqVal = Constants.createFieldValueText(false);
        this.jTextHorizontalFreqUnit = Constants.createSubFieldNameText("KHz");
    }

    private void addVeritcalFreq() {
        this.vcpCodes[1] = new VCPCodes("Vertical Frequency", "AE", "RO", "C");
        this.jTextVerticalFreqVal = Constants.createFieldValueText(false);
        this.jTextVerticalFreqUnit = Constants.createSubFieldNameText("Hz");
    }

    private void addSourceTimingMode() {
        this.vcpCodes[2] = new VCPCodes("Source Timing Mode", "B4", "R/W", "T");
        this.jTextDTVTimingMode = Constants.createSubFieldNameText("DMT Timing Modes:");
        this.jComboDTVTimingMode = new JComboBox();
        this.jComboDTVTimingMode.setModel(new DefaultComboBoxModel<String>(new String[]{"Reserved", "01h - 640 x 350 @ 85 Hz", "02h - 640 x 400 @ 85 Hz", "03h - 720 x 400 @ 85 Hz", "04h - 640 X 480 @ 60 Hz", "05h - 640 X 480 @ 72 Hz", "06h - 640 X 480 @ 75 Hz", "07h - 640 X 480 @ 85 Hz", "08h - 800 x 600 @ 56 Hz", "09h - 800 X 600 @ 60 Hz", "0Ah - 800 x 600 @ 72 Hz", "0Bh - 800 x 600 @ 75 Hz", "0Ch - 800 x 600 @ 85 Hz", "0Dh - 848 x 480 @ 60 Hz", "0Eh - 1024 x 768 @ 43 Hz interlaced", "0Fh - 1024 x 768 @ 60 Hz", "10h - 1024 x 768 @ 70 Hz", "11h - 1024 x 768 @ 75 Hz", "12h - 1024 x 768 @ 85 Hz", "13h - 1152 x 864 @ 75 Hz", "14h - 1280 x 768 @ 60 Hz - RB", "15h - 1280 x 768 @ 60 Hz", "16h - 1280 x 768 @ 75 Hz", "17h - 1280 x 768 @ 85 Hz", "18h - 1280 x 960 @ 60 Hz", "19h - 1280 x 960 @ 85 Hz", "1Ah - 1280 x 1024 @ 60 Hz", "1Bh - 1280 x 1024 @ 75 Hz", "1Ch - 1280 x 1024 @ 85 Hz", "1Dh - 1360 x 768 @ 60 Hz", "1Eh - 1400 x 1050 @ 60 Hz - RB", "1Fh - 1400 x 1050 @ 60 Hz", "20h - 1400 x 1050 @ 75 Hz", "21h - 1400 x 1050 @ 85 Hz", "22h - 1440 x 900 @ 60 Hz - RB", "23h - 1440 x 900 @ 60 Hz", "24h - 1440 x 900 @ 75 Hz", "25h - 1440 x 900 @ 85 Hz", "26h - 1600 x 1200 @ 60 Hz", "27h - 1600 x 1200 @ 65 Hz", "28h - 1600 x 1200 @ 70 Hz", "29h - 1600 x 1200 @ 75 Hz", "2Ah - 1600 x 1200 @ 85 Hz", "2Bh - 1680 x 1050 @ 60 Hz - RB", "2Ch - 1680 x 1050 @ 60 Hz", "2Dh - 1680 x 1050 @ 75 Hz", "2Eh - 1680 x 1050 @ 85 Hz", "2Fh - 1792 x 1344 @ 60 Hz", "30h - 1792 x 1344 @ 75 Hz", "31h - 1856 x 1392 @ 60 Hz", "32h - 1856 x 1392 @ 75 Hz", "33h - 1920 x 1200 @ 60 Hz \u2013 RB", "34h - 1920 x 1200 @ 60 Hz", "35h - 1920 x 1200 @ 75 Hz", "36h - 1920 x 1200 @ 85 Hz", "37h - 1920 x 1440 @ 60 Hz", "38h - 1920 x 1440 @ 75 Hz"}));
        this.jTextDMTTimingMode = Constants.createSubFieldNameText("DTV Timing Modes:");
        this.jComboDMTTimingMode = new JComboBox();
        this.jComboDMTTimingMode.setModel(new DefaultComboBoxModel<String>(new String[]{"Reserved", "01h - 640 x 400p @ 59.94/60 Hz 4:3 AR", "02h - 720 x 480p @ 59.94/60 Hz 4:3 AR", "03h - 720 x 480p @ 59.94/60 Hz 16:9 AR", "04h - 1280 x 720p @ 59.94/60 Hz 16:9 AR", "05h - 1920 x 1080i @ 59.94/60 Hz 16:9 AR", "06h - 720(1440) x 480i @ 59.94/60 Hz 4:3 AR", "07h - 720(1440) x 480i @ 59.94/60 Hz 16:9 AR", "08h - 720(1440) x 240p @ 59.94/60 Hz 4:3 AR", "09h - 720(1440) x 240p @ 59.94/60 Hz 16:9 AR", "0Ah - (2880) x 480i @ 59.94/60 Hz 4:3 AR", "0Bh - (2880) x 480i @ 59.94/60 Hz 16:9 AR", "0Ch - (2880) x 240p @ 59.94/60 Hz 4:3 AR", "0Dh - (2880) x 240p @ 59.94/60 Hz 16:9 AR", "0Eh - 1440 x 480p @ 59.94/60 Hz 4:3 AR", "0Fh - 1440 x 480p @ 59.94/60 Hz 16:9 AR", "10h - 1920 x 1080p @ 59.94/60 Hz 16:9 AR", "11h - 720 x 576p @ 50 Hz 4:3 AR", "12h - 720 x 576p @ 50 Hz 16:9 AR", "13h - 1280 x 720p @ 50 Hz 16:9 AR", "14h - 1920 x 1080i @ 50 Hz 16:9 AR", "15h - 720(1440) x 576i @ 50 Hz 4:3 AR", "16h - 720(1440) x 576i @ 50 Hz 16:9 AR", "17h - 720(1440) x 288p @ 50 Hz 4:3 AR", "18h - 720(1440) x 288p @ 50 Hz 16:9 AR", "19h - (2880) x 576i @ 50 Hz 4:3 AR", "1Ah - (2880) x 576i @ 50 Hz 16:9 AR", "1Bh - (2880) x 288p @ 50 Hz 4:3 AR", "1Ch - (2880) x 288p @ 50 Hz 16:9 AR", "1Dh - 1440 x 576p @ 50 Hz 4:3 AR", "1Eh - 1440 x 576p @ 50 Hz 16:9 AR", "1Fh - 1920 x 1080p @ 50 Hz 16:9 AR", "20h - 1920 x 1080p @ 23.97/24 Hz 16:9 AR", "21h - 1920 x 1080p @ 25 Hz 16:9 AR", "22h - 1920 x 1080p @ 29.97/30 Hz 16:9 AR", "23h - 2880 x 480p @ 59.94/60 Hz 4:3 AR", "24h - 2880 x 480p @ 59.94/60 Hz 16:9 AR", "25h - 2880 x 576p @ 50 Hz 4:3 AR", "26h - 2880 x 576p @ 50 Hz 16:9 AR", "27h - 1920 x 1080i @ 50 Hz 16:9 AR", "28h - 1920 x 1080i @100 Hz 16:9 AR", "29h - 1280 x 720p @100 Hz 16:9 AR", "2Ah - 720 x 576p @100 Hz 4:3 AR", "2Bh - 720 x 576p @100 Hz 16:9 AR", "2Ch - 720(1440) x 576i @100 Hz 4:3 AR", "2Dh - 720(1440) x 576i @100 Hz 16:9 AR", "2Eh - 1920 x 1080i @119.88 / 120 Hz 16:9 AR", "2Fh - 1280 x 720p @119.88 / 120 Hz 16:9 AR", "30h - 720 x 480p @119.88 / 120 Hz 4:3 AR", "31h - 720 x 480p @119.88 / 120 Hz 16:9 AR", "32h - 720(1440) x 480i @119.88 / 120 Hz 4:3 AR", "33h - 720(1440) x 480i @119.88 / 120 Hz 16:9 AR", "34h - 720 x 576p @ 200 Hz 4:3 AR", "35h - 720 x 576p @ 200 Hz 16:9 AR", "36h - 720(1440) x 576i @ 200 Hz 4:3 AR", "37h - 720(1440) x 576i @ 200 Hz 16:9 AR", "38h - 720 x 480p @ 239.76 / 240 Hz 4:3 AR", "39h - 720 x 480p @ 239.76 / 240 Hz 16:9 AR", "3Ah - 720(1440) x 480i @ 239.76 / 240 Hz 4:3 AR", "3Bh - 720(1440) x 480i @ 239.76 / 240 Hz 16:9 AR"}));
        this.jCheckCVTDefined = Constants.createCheckbox("CVT descriptor defined", this);
        this.jCvtPanel = new JPanel();
        this.jTextVSize = Constants.createSubFieldNameText("VSize:");
        this.jTextVSizeVal = Constants.createFieldValueText(true);
        this.jTextVSizeVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 3));
        this.jTextVSizeVal.setText("000");
        this.jTextAspectRatio = Constants.createSubFieldNameText("Aspect Ratio:");
        this.jComboAspectRatio = new JComboBox();
        this.jComboAspectRatio.setModel(new DefaultComboBoxModel<String>(new String[]{"4:3", "16:9", "16:10", "Reserved"}));
        this.jTextPreferredRefreshRate = Constants.createSubFieldNameText("Preferred Refresh Rate:");
        this.jComboPreferredRefreshRate = new JComboBox();
        this.jComboPreferredRefreshRate.setModel(new DefaultComboBoxModel<String>(new String[]{"50 Hz", "60 Hz", "75 Hz", "85 Hz"}));
        this.jTextSupportedRefreshRate = Constants.createSubFieldNameText("Supported Refresh Rate:");
        this.jCheckSupport50Hz = Constants.createCheckbox("50 Hz supported", this);
        this.jCheckSupport60Hz = Constants.createCheckbox("60 Hz supported", this);
        this.jCheckSupport75Hz = Constants.createCheckbox("75 Hz supported", this);
        this.jCheckSupport85Hz = Constants.createCheckbox("85 Hz supported", this);
        this.jCheckSupport60HzReduced = Constants.createCheckbox("60 Hz reduced blanking supported", this);
        this.jSetSourceTimingModeButton = Constants.createSetButton(this);
    }

    private void addSourceColorCoding() {
        this.vcpCodes[3] = new VCPCodes("Source Color Coding", "B5", "WO", "NC", 4);
        this.vcpCodes[3].setValueDetails(0, "00", "RGB 4:4:4");
        this.vcpCodes[3].setValueDetails(1, "01", "YCbCr / YPbPr 4:4:4");
        this.vcpCodes[3].setValueDetails(2, "02", "YCbCr / YPbPr 4:2:2");
        this.vcpCodes[3].setValueDetails(3, "", "Reserved");
        this.vcpCodes[3].setValueForReserved(3);
        this.jComboSourceColorCoding = new JComboBox();
        this.jComboSourceColorCoding.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[3])));
        this.jComboSourceColorCoding.setSelectedIndex(0);
        this.jSetSourceColorCodingButton = Constants.createSetButton(this);
    }

    private void addDisplayUsageTime() {
        this.vcpCodes[4] = new VCPCodes("Display Usage Time", "C0", "RO", "C");
        this.jTextDisplayUsageTimeVal = Constants.createFieldValueText(false);
        this.jTextDisplayUsageTimeVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 8));
        this.jTextDisplayUsageTimeVal.setText("00000000");
    }

    private void addDisplayControllerType() {
        this.vcpCodes[5] = new VCPCodes("Display Controller Type", "C8", "RO", "NC");
        this.jControllerManufacturer = new String[]{"Reserved", "Conexant", "Genesis Microchip", "Macronix", "MRT (Media Reality Technologies)", "Mstar Semiconductor", "Myson", "Philips", "PixelWorks", "RealTek Semiconductor", "Sage", "Silicon Image", "SmartASIC", "STMicroelectronics", "Topro", "Trumpion", "Welltrend", "Samsung", "Novatek Microelectrtonics", "STK", "Silicon Optix Inc.", "Not defined"};
        this.jTextControllerManufacturer = Constants.createSubFieldNameText("Controller Manufacturer:");
        this.jTextControllerManufacturerVal = Constants.createFieldValueText(false);
        this.jTextControllerManufacturerVal.setText(this.jControllerManufacturer[20]);
        this.jTextControllerTypeNum = Constants.createSubFieldNameText("Controller Type:");
        this.jTextControllerTypeNumVal = Constants.createFieldValueText(false);
        this.jTextControllerTypeNumVal.setText("00");
    }

    private void addDisplayFirmwareLevel() {
        this.vcpCodes[6] = new VCPCodes("Display Firmware Level", "C9", "RO", "C");
        this.jTextDisplayFirmwareLevelVal = Constants.createFieldValueText(false);
        this.jTextDisplayFirmwareLevelVal.setText("0.0");
    }

    private void addOSD() {
        this.vcpCodes[7] = new VCPCodes("OSD", "CA", "R/W", "NC", 4);
        this.vcpCodes[7].setValueDetails(0, "", "Reserved");
        this.vcpCodes[7].setValueDetails(1, "01", "OSD is disabled");
        this.vcpCodes[7].setValueDetails(2, "02", "OSD is enabled");
        this.vcpCodes[7].setValueDetails(3, "FF", "Display cannot supply this information");
        this.vcpCodes[7].setValueForReserved(0);
        this.jComboOsd = new JComboBox();
        this.jComboOsd.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[7])));
        this.jSetOsdButton = Constants.createSetButton(this);
    }

    private void addOSDLanguage() {
        this.vcpCodes[8] = new VCPCodes("OSD Language", "CC", "R/W", "NC", 38);
        this.vcpCodes[8].setValueDetails(0, "", "Reserved");
        this.vcpCodes[8].setValueDetails(1, "01", "Chinese (traditional / Hantai)");
        this.vcpCodes[8].setValueDetails(2, "02", "English");
        this.vcpCodes[8].setValueDetails(3, "03", "French");
        this.vcpCodes[8].setValueDetails(4, "04", "German");
        this.vcpCodes[8].setValueDetails(5, "05", "Italian");
        this.vcpCodes[8].setValueDetails(6, "06", "Japanese");
        this.vcpCodes[8].setValueDetails(7, "07", "Korean");
        this.vcpCodes[8].setValueDetails(8, "08", "Portuguese (Portugal)");
        this.vcpCodes[8].setValueDetails(9, "09", "Russian");
        this.vcpCodes[8].setValueDetails(10, "0A", "Spanish");
        this.vcpCodes[8].setValueDetails(11, "0B", "Swedish");
        this.vcpCodes[8].setValueDetails(12, "0C", "Turkish");
        this.vcpCodes[8].setValueDetails(13, "0D", "Chinese (simplified / Kantai)");
        this.vcpCodes[8].setValueDetails(14, "0E", "Portuguese (Brazil)");
        this.vcpCodes[8].setValueDetails(15, "0F", "Arabic");
        this.vcpCodes[8].setValueDetails(16, "10", "Bulgarian");
        this.vcpCodes[8].setValueDetails(17, "11", "Croatian");
        this.vcpCodes[8].setValueDetails(18, "12", "Czech");
        this.vcpCodes[8].setValueDetails(19, "13", "Danish");
        this.vcpCodes[8].setValueDetails(20, "14", "Dutch");
        this.vcpCodes[8].setValueDetails(21, "15", "Estonian");
        this.vcpCodes[8].setValueDetails(22, "16", "Finnish");
        this.vcpCodes[8].setValueDetails(23, "17", "Greek");
        this.vcpCodes[8].setValueDetails(24, "18", "Hebrew");
        this.vcpCodes[8].setValueDetails(25, "19", "Hindi");
        this.vcpCodes[8].setValueDetails(26, "1A", "Hungarian");
        this.vcpCodes[8].setValueDetails(27, "1B", "Latvian");
        this.vcpCodes[8].setValueDetails(28, "1C", "Lithuanian");
        this.vcpCodes[8].setValueDetails(29, "1D", "Norwegian");
        this.vcpCodes[8].setValueDetails(30, "1E", "Polish");
        this.vcpCodes[8].setValueDetails(31, "1F", "Romanian");
        this.vcpCodes[8].setValueDetails(32, "20", "Serbian");
        this.vcpCodes[8].setValueDetails(33, "21", "Slovak");
        this.vcpCodes[8].setValueDetails(34, "22", "Slovenian");
        this.vcpCodes[8].setValueDetails(35, "23", "Thai");
        this.vcpCodes[8].setValueDetails(36, "24", "Ukrainian");
        this.vcpCodes[8].setValueDetails(37, "25", "Vietnamese");
        this.vcpCodes[8].setValueForReserved(0);
        this.jComboOsdLanguage = new JComboBox();
        this.jComboOsdLanguage.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[8])));
        this.jSetOsdLanguageButton = Constants.createSetButton(this);
    }

    private void addPowerMode() {
        this.vcpCodes[9] = new VCPCodes("Power Mode", "D6", "R/W", "NC", 6);
        this.vcpCodes[9].setValueDetails(0, "", "Reserved");
        this.vcpCodes[9].setValueDetails(1, "01", "On (DPMS) or On (DPM)");
        this.vcpCodes[9].setValueDetails(2, "02", "Standby (DPMS) or Off (DPM)");
        this.vcpCodes[9].setValueDetails(3, "03", "Suspend (DPMS) or Off (DPM)");
        this.vcpCodes[9].setValueDetails(4, "04", "Off (DPMS) or Off (DPM)");
        this.vcpCodes[9].setValueDetails(5, "05", "Power Off the display");
        this.vcpCodes[9].setValueForReserved(0);
        this.jComboPowerMode = new JComboBox();
        this.jComboPowerMode.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[9])));
        this.jSetPowerModeButton = Constants.createSetButton(this);
    }

    private void addImageMode() {
        this.vcpCodes[10] = new VCPCodes("Image Mode", "DB", "R/Q", "NC", 6);
        this.vcpCodes[10].setValueDetails(0, "00", "No effect");
        this.vcpCodes[10].setValueDetails(1, "01", "Full Mode");
        this.vcpCodes[10].setValueDetails(2, "02", "Zoom Mode");
        this.vcpCodes[10].setValueDetails(3, "03", "Squeeze Mode");
        this.vcpCodes[10].setValueDetails(4, "04", "Variable");
        this.vcpCodes[10].setValueDetails(5, "", "Reserved");
        this.vcpCodes[10].setValueForReserved(5);
        this.jComboImageMode = new JComboBox();
        this.jComboImageMode.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[10])));
        this.jSetImageModeButton = Constants.createSetButton(this);
    }

    private void addVCPVersion() {
        this.vcpCodes[11] = new VCPCodes("VCP Version", "DF", "RO", "NC");
        this.jTextVCPVerNumber = Constants.createFieldValueText(false);
        this.jTextVCPVerNumber.setText("2.0");
    }

    private void constructPanel() {
        GroupLayout groupLayout = new GroupLayout(this.jCvtPanel);
        this.jCvtPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(1).add(groupLayout.createSequentialGroup().add(groupLayout.createParallelGroup(1).add(this.jTextSupportedRefreshRate, -2, -1, -2).add(this.jTextPreferredRefreshRate, -2, -1, -2).add(this.jTextAspectRatio, -2, -1, -2).add(this.jTextVSize, -2, -1, -2)).add(23, 23, 23).add(groupLayout.createParallelGroup(1).add(this.jTextVSizeVal, -2, 40, -2).add(this.jComboAspectRatio, -2, -1, -2).add(this.jComboPreferredRefreshRate, -2, -1, -2).add(this.jCheckSupport60HzReduced).add(this.jCheckSupport85Hz).add(this.jCheckSupport75Hz).add(this.jCheckSupport60Hz).add(this.jCheckSupport50Hz)).addContainerGap(203, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(1).add(groupLayout.createSequentialGroup().add(groupLayout.createParallelGroup(3).add(this.jTextVSize, -2, -1, -2).add(this.jTextVSizeVal, -2, 28, -2)).addPreferredGap(0).add(groupLayout.createParallelGroup(3).add(this.jTextAspectRatio, -2, -1, -2).add(this.jComboAspectRatio, -2, 28, -2)).addPreferredGap(0).add(groupLayout.createParallelGroup(3).add(this.jTextPreferredRefreshRate, -2, -1, -2).add(this.jComboPreferredRefreshRate, -2, 28, -2)).addPreferredGap(0).add(groupLayout.createParallelGroup(3).add(this.jTextSupportedRefreshRate, -2, -1, -2).add(this.jCheckSupport50Hz)).add(this.jCheckSupport60Hz).add(this.jCheckSupport75Hz).add(this.jCheckSupport85Hz).add(this.jCheckSupport60HzReduced).addContainerGap(-1, Short.MAX_VALUE)));
        this.jCvtPanel.setVisible(false);
        this.layout.setHorizontalGroup(this.layout.createParallelGroup(1).add(this.layout.createSequentialGroup().add(36, 36, 36).add(this.layout.createParallelGroup(1).add(this.vcpCodes[5].getNameField(), -2, -1, -2).add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.vcpCodes[0].getNameField(), -2, -1, -2).add(this.vcpCodes[1].getNameField(), -2, -1, -2).add(this.vcpCodes[2].getNameField(), -2, -1, -2).add(this.vcpCodes[3].getNameField(), -2, -1, -2).add(this.vcpCodes[4].getNameField(), -2, -1, -2).add(this.vcpCodes[6].getNameField(), -2, -1, -2).add(this.vcpCodes[7].getNameField(), -2, -1, -2).add(this.vcpCodes[8].getNameField(), -2, -1, -2).add(this.vcpCodes[9].getNameField(), -2, -1, -2).add(this.vcpCodes[10].getNameField(), -2, -1, -2).add(this.vcpCodes[11].getNameField(), -2, -1, -2)).add(23, 23, 23).add(this.layout.createParallelGroup(1).add(this.jTextVCPVerNumber, -2, 40, -2).add(this.jTextDisplayFirmwareLevelVal, -2, 40, -2).add(this.layout.createSequentialGroup().add(this.jTextControllerManufacturer, -2, -1, -2).add(25, 25, 25).add(this.jTextControllerManufacturerVal, -2, -1, -2)).add(this.layout.createSequentialGroup().add(this.jTextControllerTypeNum, -2, -1, -2).add(25, 25, 25).add(this.jTextControllerTypeNumVal, -2, -1, -2)).add(this.jTextDisplayUsageTimeVal, -2, -1, -2).add(this.layout.createSequentialGroup().add(this.jComboSourceColorCoding, -2, -1, -2).add(25, 25, 25).add(this.jSetSourceColorCodingButton)).add(this.layout.createSequentialGroup().add(this.jTextVerticalFreqVal, -2, 80, -2).add(3, 3, 3).add(this.jTextVerticalFreqUnit, -2, -1, -2)).add(this.layout.createSequentialGroup().add(this.jTextHorizontalFreqVal, -2, 80, -2).add(3, 3, 3).add(this.jTextHorizontalFreqUnit, -2, -1, -2)).add(this.layout.createSequentialGroup().add(this.jTextDTVTimingMode, -2, -1, -2).add(25, 25, 25).add(this.jComboDTVTimingMode, -2, -1, -2)).add(this.layout.createSequentialGroup().add(this.jTextDMTTimingMode, -2, -1, -2).add(25, 25, 25).add(this.jComboDMTTimingMode, -2, -1, -2).add(50, 50, 50).add(this.jSetSourceTimingModeButton, -2, -1, -2)).add(this.jCheckCVTDefined, -2, -1, -2).add(this.jCvtPanel, -2, -1, -2).add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.jComboOsd, -2, -1, -2).add(this.jComboOsdLanguage, -2, -1, -2).add(this.jComboPowerMode, -2, -1, -2).add(this.jComboImageMode, -2, -1, -2)).add(24, 24, 24).add(this.layout.createParallelGroup(1).add(this.jSetImageModeButton).add(this.jSetPowerModeButton).add(this.jSetOsdLanguageButton).add(this.jSetOsdButton)))))).addContainerGap(167, Short.MAX_VALUE)));
        this.layout.setVerticalGroup(this.layout.createParallelGroup(1).add(this.layout.createSequentialGroup().add(36, 36, 36).add(this.layout.createParallelGroup(3).add(this.vcpCodes[0].getNameField(), -2, -1, -2).add(this.jTextHorizontalFreqVal, -2, -1, -2).add(this.jTextHorizontalFreqUnit, -2, -1, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[1].getNameField(), -2, -1, -2).add(this.jTextVerticalFreqVal, -2, -1, -2).add(this.jTextVerticalFreqUnit, -2, -1, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[2].getNameField(), -2, -1, -2).add(this.jTextDTVTimingMode, -2, 20, -2).add(this.jComboDTVTimingMode, -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextDMTTimingMode, -2, -1, -2).add(this.jComboDMTTimingMode, -2, 28, -2).add(this.jSetSourceTimingModeButton, -2, 20, -2)).addPreferredGap(0).add(this.jCheckCVTDefined, -2, -1, -2).addPreferredGap(0).add(this.jCvtPanel, -2, -1, -2).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[3].getNameField(), -2, -1, -2).add(this.jComboSourceColorCoding, -2, 28, -2).add(this.jSetSourceColorCodingButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[4].getNameField(), -2, -1, -2).add(this.jTextDisplayUsageTimeVal, -2, 28, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[5].getNameField(), -2, -1, -2).add(this.jTextControllerManufacturer, -2, 28, -2).add(this.jTextControllerManufacturerVal, -2, 28, -2)).addPreferredGap(0).add(this.layout.createParallelGroup(3).add(this.jTextControllerTypeNum, -2, 28, -2).add(this.jTextControllerTypeNumVal, -2, 28, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[6].getNameField(), -2, -1, -2).add(this.jTextDisplayFirmwareLevelVal, -2, 28, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[7].getNameField(), -2, -1, -2).add(this.jComboOsd, -2, 28, -2).add(this.jSetOsdButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[8].getNameField(), -2, -1, -2).add(this.jComboOsdLanguage, -2, 28, -2).add(this.jSetOsdLanguageButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[9].getNameField(), -2, -1, -2).add(this.jComboPowerMode, -2, 28, -2).add(this.jSetPowerModeButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[10].getNameField(), -2, -1, -2).add(this.jComboImageMode, -2, 28, -2).add(this.jSetImageModeButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[11].getNameField(), -2, -1, -2).add(this.jTextVCPVerNumber, -2, 28, -2)).addContainerGap(17, Short.MAX_VALUE)));
    }

    public void getAllValues(boolean bl, boolean bl2) {
        if (MCCSGUIFrame.allConnected(bl)) {
            this.getHorizontalFreq(bl2);
            this.getVerticalFreq(bl2);
            this.getSourceTimingMode(bl2);
            this.getDisplayUsageTime(bl2);
            this.getDisplayControllerType(bl2);
            this.getDisplayFirmwareLevel(bl2);
            this.getOSD(bl2);
            this.getOSDLanguage(bl2);
            this.getPowerMode(bl2);
            this.getImageMode(bl2);
            this.getVCPVersion(bl2);
            this.revalidate();
        }
    }

    public void refreshPanelContents() {
        boolean bl = this.vcpCodes[0].isSupported();
        this.jTextHorizontalFreqVal.setEnabled(bl);
        this.jTextHorizontalFreqUnit.setEnabled(bl);
        bl = this.vcpCodes[1].isSupported();
        this.jTextVerticalFreqVal.setEnabled(bl);
        this.jTextVerticalFreqUnit.setEnabled(bl);
        bl = this.vcpCodes[2].isSupported();
        this.jTextDTVTimingMode.setEnabled(bl);
        this.jComboDTVTimingMode.setEnabled(bl);
        this.jTextDMTTimingMode.setEnabled(bl);
        this.jComboDMTTimingMode.setEnabled(bl);
        this.jCheckCVTDefined.setEnabled(bl);
        this.jTextVSize.setEnabled(bl);
        this.jTextVSizeVal.setEnabled(bl);
        this.jTextAspectRatio.setEnabled(bl);
        this.jComboAspectRatio.setEnabled(bl);
        this.jTextPreferredRefreshRate.setEnabled(bl);
        this.jComboPreferredRefreshRate.setEnabled(bl);
        this.jTextSupportedRefreshRate.setEnabled(bl);
        this.jCheckSupport50Hz.setEnabled(bl);
        this.jCheckSupport60Hz.setEnabled(bl);
        this.jCheckSupport75Hz.setEnabled(bl);
        this.jCheckSupport85Hz.setEnabled(bl);
        this.jCheckSupport60HzReduced.setEnabled(bl);
        this.jSetSourceTimingModeButton.setEnabled(bl);
        bl = this.vcpCodes[3].isSupported();
        this.jComboSourceColorCoding.setEnabled(bl);
        this.jSetSourceColorCodingButton.setEnabled(bl);
        if (bl) {
            this.jComboSourceColorCoding.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[3])));
        }
        bl = this.vcpCodes[4].isSupported();
        this.jTextDisplayUsageTimeVal.setEnabled(bl);
        bl = this.vcpCodes[5].isSupported();
        this.jTextControllerManufacturer.setEnabled(bl);
        this.jTextControllerManufacturerVal.setEnabled(bl);
        this.jTextControllerTypeNum.setEnabled(bl);
        this.jTextControllerTypeNumVal.setEnabled(bl);
        bl = this.vcpCodes[6].isSupported();
        this.jTextDisplayFirmwareLevelVal.setEnabled(bl);
        bl = this.vcpCodes[7].isSupported();
        this.jComboOsd.setEnabled(bl);
        this.jSetOsdButton.setEnabled(bl);
        if (bl) {
            this.jComboOsd.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[7])));
        }
        bl = this.vcpCodes[8].isSupported();
        this.jComboOsdLanguage.setEnabled(bl);
        this.jSetOsdLanguageButton.setEnabled(bl);
        if (bl) {
            this.jComboOsdLanguage.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[8])));
        }
        bl = this.vcpCodes[9].isSupported();
        this.jComboPowerMode.setEnabled(bl);
        this.jSetPowerModeButton.setEnabled(bl);
        if (bl) {
            this.jComboPowerMode.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[9])));
        }
        bl = this.vcpCodes[10].isSupported();
        this.jComboImageMode.setEnabled(bl);
        this.jSetImageModeButton.setEnabled(bl);
        if (bl) {
            this.jComboImageMode.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[10])));
        }
        bl = this.vcpCodes[11].isSupported();
        this.jTextVCPVerNumber.setEnabled(bl);
    }

    private void getHorizontalFreq(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[0], bl) != 0) {
            if (MCCSGUIFrame.getReadRespMH() == 255 && MCCSGUIFrame.getReadRespML() == 255 && MCCSGUIFrame.getReadRespSH() == 255 && MCCSGUIFrame.getReadRespSL() == 255) {
                this.jTextHorizontalFreqVal.setText("The display cannot dtermine the frequency or it is out of range");
            } else {
                int n = MCCSGUIFrame.getReadRespMH() << 24 | MCCSGUIFrame.getReadRespML() << 16 | MCCSGUIFrame.getReadRespSH() << 8 | MCCSGUIFrame.getReadRespSL();
                double d = (double)n / 1000.0;
                this.jTextHorizontalFreqVal.setText(String.valueOf(d) + " KHz");
            }
        }
    }

    private void getVerticalFreq(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[1], bl) != 0) {
            if (MCCSGUIFrame.getReadRespMH() == 255 && MCCSGUIFrame.getReadRespML() == 255 && MCCSGUIFrame.getReadRespSH() == 255 && MCCSGUIFrame.getReadRespSL() == 255) {
                this.jTextVerticalFreqVal.setText("The display cannot dtermine the frequency or it is out of range");
            } else {
                double d = (double)MCCSGUIFrame.getReadRespCurrentValue() / 1000.0;
                this.jTextVerticalFreqVal.setText(String.valueOf(d) + " Hz");
            }
        }
    }

    private void getSourceTimingMode(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[2], 5, bl) != 0) {
            int n = MCCSGUIFrame.getReadRespByte(0);
            if (n >= 57) {
                this.jComboDTVTimingMode.setSelectedIndex(0);
            } else {
                this.jComboDTVTimingMode.setSelectedIndex(n);
            }
            n = MCCSGUIFrame.getReadRespByte(1);
            if (n >= 60) {
                this.jComboDMTTimingMode.setSelectedIndex(0);
            } else {
                this.jComboDMTTimingMode.setSelectedIndex(n);
            }
            if (MCCSGUIFrame.getReadRespByte(2) == 0 && MCCSGUIFrame.getReadRespByte(3) == 0 && MCCSGUIFrame.getReadRespByte(4) == 0) {
                this.jCheckCVTDefined.setSelected(false);
                this.jCvtPanel.setVisible(false);
            } else {
                this.jCheckCVTDefined.setSelected(true);
                this.jCvtPanel.setVisible(true);
                int n2 = MCCSGUIFrame.getReadRespByte(2);
                int n3 = MCCSGUIFrame.getReadRespByte(1);
                int n4 = n2 + ((n3 & 0xF0) << 4);
                this.jTextVSizeVal.setText(String.valueOf(n4));
                this.jComboAspectRatio.setSelectedIndex((n3 & 0xC) >> 2);
                n = MCCSGUIFrame.getReadRespByte(0);
                this.jComboPreferredRefreshRate.setSelectedIndex((n & 0x60) >> 5);
                this.jCheckSupport50Hz.setSelected((n & 0x10) == 16);
                this.jCheckSupport60Hz.setSelected((n & 8) == 8);
                this.jCheckSupport75Hz.setSelected((n & 4) == 4);
                this.jCheckSupport85Hz.setSelected((n & 2) == 2);
                this.jCheckSupport60HzReduced.setSelected((n & 1) == 1);
            }
        }
    }

    private void setSourceTimingMode() {
        String string;
        int n;
        String string2 = Integer.toHexString(this.jComboDTVTimingMode.getSelectedIndex());
        string2 = string2 + " ";
        string2 = string2 + Integer.toHexString(this.jComboDMTTimingMode.getSelectedIndex());
        String string3 = this.jTextVSizeVal.getText();
        if (string3.length() <= 2) {
            n = 0;
            string = string3;
        } else {
            n = Integer.valueOf(string3.substring(0, 1), 16);
            string = string3.substring(1, 3);
        }
        int n2 = n << 4 | this.jComboAspectRatio.getSelectedIndex() << 2;
        string2 = string2 + " " + string;
        string2 = string2 + " " + Integer.toHexString(n2);
        n2 = 0 | this.jComboPreferredRefreshRate.getSelectedIndex() << 5;
        if (this.jCheckSupport50Hz.isSelected()) {
            n2 |= 0x10;
        }
        if (this.jCheckSupport60Hz.isSelected()) {
            n2 |= 8;
        }
        if (this.jCheckSupport75Hz.isSelected()) {
            n2 |= 4;
        }
        if (this.jCheckSupport85Hz.isSelected()) {
            n2 |= 2;
        }
        if (this.jCheckSupport60HzReduced.isSelected()) {
            n2 |= 1;
        }
        string2 = string2 + " " + Integer.toHexString(n2);
        MCCSGUIFrame.writeStringToDisplay(this.vcpCodes[2], string2, 5);
    }

    private void getDisplayUsageTime(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[4], bl) != 0) {
            int n = 0;
            n |= MCCSGUIFrame.getReadRespML() << 16;
            n |= MCCSGUIFrame.getReadRespSH() << 8;
            this.jTextDisplayUsageTimeVal.setText(String.valueOf(n |= MCCSGUIFrame.getReadRespSL()) + " hours");
        }
    }

    private void getDisplayControllerType(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[5], bl) != 0) {
            int n = MCCSGUIFrame.getReadRespSL();
            if (n == 255) {
                this.jTextControllerManufacturerVal.setText(this.jControllerManufacturer[21]);
            } else if (n >= 1 && n <= 20) {
                this.jTextControllerManufacturerVal.setText(this.jControllerManufacturer[n]);
            } else {
                this.jTextControllerManufacturerVal.setText(this.jControllerManufacturer[0]);
            }
            n = 0;
            n |= MCCSGUIFrame.getReadRespMH() << 16;
            n |= MCCSGUIFrame.getReadRespML() << 8;
            this.jTextControllerTypeNumVal.setText(String.valueOf(n |= MCCSGUIFrame.getReadRespSH()));
        }
    }

    private void getDisplayFirmwareLevel(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[6], bl) != 0) {
            this.jTextDisplayFirmwareLevelVal.setText(Integer.toHexString(MCCSGUIFrame.getReadRespSH()) + "." + Integer.toHexString(MCCSGUIFrame.getReadRespSL()));
        }
    }

    private void getOSD(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[7], bl) != 0) {
            this.jComboOsd.setSelectedItem(this.vcpCodes[7].getDetailByCmdValue(MCCSGUIFrame.getReadRespSL()));
        }
    }

    private void getOSDLanguage(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[8], bl) != 0) {
            this.jComboOsdLanguage.setSelectedItem(this.vcpCodes[8].getDetailByCmdValue(MCCSGUIFrame.getReadRespSL()));
        }
    }

    private void getPowerMode(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[9], bl) != 0) {
            this.jComboPowerMode.setSelectedItem(this.vcpCodes[9].getDetailByCmdValue(MCCSGUIFrame.getReadRespSL()));
        }
    }

    private void getImageMode(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[10], bl) != 0) {
            this.jComboImageMode.setSelectedItem(this.vcpCodes[10].getDetailByCmdValue(MCCSGUIFrame.getReadRespSL()));
        }
    }

    private void getVCPVersion(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[11], bl) != 0) {
            this.jTextVCPVerNumber.setText(Integer.toHexString(MCCSGUIFrame.getReadRespSH()) + "." + Integer.toHexString(MCCSGUIFrame.getReadRespSL()));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jCheckCVTDefined) {
            if (this.jCheckCVTDefined.isSelected()) {
                this.jCvtPanel.setVisible(true);
            } else {
                this.jCvtPanel.setVisible(false);
            }
        } else if (MCCSGUIFrame.allConnected(true)) {
            if (object == this.jSetSourceTimingModeButton) {
                this.setSourceTimingMode();
            } else if (object == this.jSetSourceColorCodingButton) {
                MCCSGUIFrame.writeToDisplay((String)this.jComboSourceColorCoding.getSelectedItem(), this.vcpCodes[3]);
            } else if (object == this.jSetOsdButton) {
                MCCSGUIFrame.writeToDisplay((String)this.jComboOsd.getSelectedItem(), this.vcpCodes[7]);
            } else if (object == this.jSetOsdLanguageButton) {
                MCCSGUIFrame.writeToDisplay((String)this.jComboOsdLanguage.getSelectedItem(), this.vcpCodes[8]);
            } else if (object == this.jSetPowerModeButton) {
                MCCSGUIFrame.writeToDisplay((String)this.jComboPowerMode.getSelectedItem(), this.vcpCodes[9]);
            } else if (object == this.jSetImageModeButton) {
                MCCSGUIFrame.writeToDisplay((String)this.jComboImageMode.getSelectedItem(), this.vcpCodes[10]);
            }
        }
    }
}

